﻿var recodeList = {
    context: $(".v-recode-list"),
    initialize: function () {
        $(".v-dynamicEditor", this.context).a4dynamicGrid({
            
        });
        $(".toApply:first", this.context).prop("checked", true);
        
    },
    bindEvents: function () {
        recodeList.context.on("change", ".toApply", function () {
            $(".toApply", this.context).each(function () {
                $(this).prop("checked", false);
            });
            $(this).prop("checked", true);

        });

        this.context.on("click", "#h-recodeList", function () {
            recodeList.recodeFromList();
        });

    },
    recodeFromList: function () {
        var rows = a4.parent().openEndCoding.datatable.a4datatable("getSelectedItems");
        var respondentCases = [];

        _.each(rows, function (row) {
            respondentCases.push({ CaseId: row.CaseId, Mention: row.Mention });
        });

        var recodeFromListSelectorParams = {
            projectId: $("#ProjectId", recodeList.context).val(),
            questionName: $("#QuestionName", recodeList.context).val(),
            codeSelected: $(".toApply:checked", recodeList.context).val(),
            respondentCases: respondentCases
        };

        a4.callServerMethod(a4.getProjectAction("RecodeFromCodeList", "Data"), recodeFromListSelectorParams,
                function (result) {
                    a4.parent().openEndCoding.refreshContent();
                    return modalDialog.close();
                });
        
    }
};





$(document).ready(function () {
    if (recodeList.context.length > 0) {
        recodeList.initialize();
        recodeList.bindEvents();
    }
});